/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package com.inet.application.embedded;

import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner.CombinedFile;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.RemoteGuiServerPlugin;
import com.inet.remote.gui.angular.RemoteAngularThemeService;
import com.inet.theme.server.ThemeResource;

@PluginInfo( //
                id = "application.embedded", //
                version = "25.10.259", //
                flags = "core", packages = "", //
                dependencies = "remotegui", //
                optionalDependencies = "theme", //
                icon = "com/inet/application/embedded/embeddeded_48.png", //
                group = "samples" //
)
/**
 * Plugin to have the whole interface embedded into another web page. That is: Remove the header.
 */
public class EmbeddedServerPlugin implements ServerPlugin {

    /**
     * {@inheritDoc}
     */
    @Override
    public void registerExtension( ServerPluginManager spm ) {
        // register optional additional java script
        CombinedFile combinedFile = new CombinedFile( "application/x-javascript; charset=utf-8" );
        // add at least one javascript resource
        combinedFile.add( getClass(), "webgui/embeddedMode.js" );
        spm.register( CombinedFileDescription.class, new CombinedFileDescription( RemoteGuiServerPlugin.APP_KEY, 10000, "remotegui.lib.js", combinedFile ) );

        // add styles - uncompiled
        if( spm.isPluginLoaded( "theme" ) ) {
            spm.register( ThemeResource.class, new ThemeResource( 100, RemoteAngularThemeService.THEME_APP_KEY, getClass().getResource( "webgui/embeddedMode.less" ) ) );
        }

        // add styles - precompiled
        final CombinedFile css = new CombinedFile( "text/css; charset=utf-8" );
        css.add( getClass(), "webgui/embeddedMode.css" );
        spm.register( CombinedFileDescription.class, new CombinedFileDescription( RemoteGuiServerPlugin.APP_KEY, 100, "defaulttheme.css", css ) );
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void init( ServerPluginManager spm ) {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void reset() {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void restart() {
        // nothing
    }

}
